<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'Już zresetuj hasło. Wiadomość została wysłana.',
            'back'                 => 'Powrót do logowania?',
            'bagisto'              => 'Bagisto',
            'email'                => 'Email',
            'email-not-exist'      => 'Nie możemy znaleźć użytkownika z tym adresem e-mail.',
            'footer'               => '© Prawa autorskie 2010 - :current_year, Webkul Software (zarejestrowane w Indiach). Wszelkie prawa zastrzeżone.',
            'forgot-password-text' => 'Jeśli zapomniałeś hasła, odzyskaj je, wpisując swój adres e-mail.',
            'page-title'           => 'Zapomniałeś hasła?',
            'reset-link-sent'      => 'Wysłaliśmy link resetowania hasła na Twój adres e-mail.',
            'sign-in-button'       => 'Zaloguj się',
            'submit'               => 'Zresetuj hasło',
            'title'                => 'Odzyskaj hasło',
        ],

        'reset-password' => [
            'back-link-title'  => 'Powrót do logowania',
            'bagisto'          => 'Bagisto',
            'confirm-password' => 'Potwierdź hasło',
            'email'            => 'Zarejestrowany adres e-mail',
            'footer'           => '© Prawa autorskie 2010 - :current_year, Webkul Software (zarejestrowane w Indiach). Wszelkie prawa zastrzeżone.',
            'password'         => 'Hasło',
            'submit-btn-title' => 'Zresetuj hasło',
            'title'            => 'Zresetuj hasło',
        ],

        'login-form' => [
            'bagisto'             => 'Bagisto',
            'button-title'        => 'Zaloguj się',
            'create-your-account' => 'Stwórz swoje konto',
            'email'               => 'Email',
            'footer'              => '© Prawa autorskie 2010 - :current_year, Webkul Software (zarejestrowane w Indiach). Wszelkie prawa zastrzeżone.',
            'forgot-pass'         => 'Zapomniałeś hasła?',
            'form-login-text'     => 'Jeśli masz konto, zaloguj się za pomocą swojego adresu e-mail.',
            'invalid-credentials' => 'Sprawdź swoje dane logowania i spróbuj ponownie.',
            'new-customer'        => 'Nowy klient?',
            'not-activated'       => 'Twoja aktywacja oczekuje na zatwierdzenie administratora',
            'page-title'          => 'Logowanie klienta',
            'password'            => 'Hasło',
            'show-password'       => 'Pokaż hasło',
            'title'               => 'Zaloguj się',
            'verify-first'        => 'Najpierw zweryfikuj swoje konto e-mail.',
        ],

        'signup-form' => [
            'account-exists'              => 'Masz już konto?',
            'bagisto'                     => 'Bagisto',
            'button-title'                => 'Zarejestruj',
            'click-here'                  => 'Kliknij tutaj',
            'confirm-pass'                => 'Potwierdź hasło',
            'email'                       => 'Email',
            'first-name'                  => 'Imię',
            'footer'                      => '© Prawa autorskie 2010 - :current_year, Webkul Software (zarejestrowane w Indiach). Wszelkie prawa zastrzeżone.',
            'form-signup-text'            => 'Jeśli jesteś nowym klientem w naszym sklepie, cieszymy się, że jesteś naszym członkiem.',
            'last-name'                   => 'Nazwisko',
            'page-title'                  => 'Zostań użytkownikiem',
            'password'                    => 'Hasło',
            'sign-in-button'              => 'Zaloguj się',
            'subscribe-to-newsletter'     => 'Zapisz się na newsletter',
            'success'                     => 'Konto zostało pomyślnie utworzone.',
            'success-verify'              => 'Konto zostało pomyślnie utworzone, na Twój adres e-mail została wysłana wiadomość w celu weryfikacji.',
            'success-verify-email-unsent' => 'Konto zostało pomyślnie utworzone, ale wiadomość weryfikacyjna nie została wysłana.',
            'terms-conditions'            => 'Warunki i zasady',
            'verification-not-sent'       => 'Błąd! Problem z wysłaniem wiadomości weryfikacyjnej, spróbuj ponownie później.',
            'verification-sent'           => 'Wysłano wiadomość weryfikacyjną',
            'verified'                    => 'Twoje konto zostało zweryfikowane, spróbuj teraz zalogować się.',
            'verify-failed'               => 'Nie możemy zweryfikować Twojego konta e-mail.',
        ],

        'account' => [
            'home' => 'Strona główna',

            'profile' => [
                'index' => [
                    'delete'         => 'Usuń',
                    'delete-failed'  => 'Wystąpił błąd podczas usuwania klienta.',
                    'delete-profile' => 'Usuń profil',
                    'delete-success' => 'Klient został pomyślnie usunięty',
                    'dob'            => 'Data urodzenia',
                    'edit'           => 'Edytuj',
                    'edit-success'   => 'Profil został pomyślnie zaktualizowany',
                    'email'          => 'E-mail',
                    'enter-password' => 'Wprowadź swoje hasło',
                    'first-name'     => 'Imię',
                    'gender'         => 'Płeć',
                    'last-name'      => 'Nazwisko',
                    'order-pending'  => 'Nie można usunąć konta klienta, ponieważ istnieją niezrealizowane lub przetwarzane zamówienia.',
                    'title'          => 'Profil',
                    'unmatched'      => 'Stare hasło nie pasuje.',
                    'wrong-password' => 'Nieprawidłowe hasło!',
                ],

                'edit' => [
                    'confirm-password'        => 'Potwierdź hasło',
                    'current-password'        => 'Obecne hasło',
                    'dob'                     => 'Data urodzenia',
                    'edit'                    => 'Edytuj',
                    'edit-profile'            => 'Edytuj profil',
                    'email'                   => 'E-mail',
                    'female'                  => 'Kobieta',
                    'first-name'              => 'Imię',
                    'gender'                  => 'Płeć',
                    'last-name'               => 'Nazwisko',
                    'male'                    => 'Mężczyzna',
                    'new-password'            => 'Nowe hasło',
                    'other'                   => 'Inne',
                    'phone'                   => 'Telefon',
                    'save'                    => 'Zapisz',
                    'subscribe-to-newsletter' => 'Zapisz się do newslettera',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Dodaj adres',
                    'create-success'   => 'Adres został pomyślnie dodany.',
                    'default-address'  => 'Domyślny adres',
                    'default-delete'   => 'Nie można zmienić domyślnego adresu.',
                    'delete'           => 'Usuń',
                    'delete-success'   => 'Adres został pomyślnie usunięty',
                    'edit'             => 'Edytuj',
                    'edit-success'     => 'Adres został pomyślnie zaktualizowany.',
                    'empty-address'    => 'Nie dodałeś jeszcze adresu do swojego konta.',
                    'security-warning' => 'Wykryto podejrzane działanie!!!',
                    'set-as-default'   => 'Ustaw jako domyślny',
                    'title'            => 'Adres',
                    'update-success'   => 'Adres został pomyślnie zaktualizowany.',
                ],

                'create' => [
                    'add-address'    => 'Dodaj adres',
                    'city'           => 'Miasto',
                    'company-name'   => 'Nazwa firmy',
                    'country'        => 'Kraj',
                    'email'          => 'E-mail',
                    'first-name'     => 'Imię',
                    'last-name'      => 'Nazwisko',
                    'phone'          => 'Telefon',
                    'post-code'      => 'Kod pocztowy',
                    'save'           => 'Zapisz',
                    'select-country' => 'Wybierz kraj',
                    'set-as-default' => 'Ustaw jako domyślny',
                    'state'          => 'Województwo',
                    'street-address' => 'Adres',
                    'title'          => 'Adres',
                    'vat-id'         => 'Numer VAT',
                ],

                'edit' => [
                    'city'           => 'Miasto',
                    'company-name'   => 'Nazwa firmy',
                    'country'        => 'Kraj',
                    'edit'           => 'Edytuj',
                    'email'          => 'E-mail',
                    'first-name'     => 'Imię',
                    'last-name'      => 'Nazwisko',
                    'phone'          => 'Telefon',
                    'post-code'      => 'Kod pocztowy',
                    'select-country' => 'Wybierz kraj',
                    'state'          => 'Województwo',
                    'street-address' => 'Adres',
                    'title'          => 'Adres',
                    'update-btn'     => 'Aktualizuj',
                    'vat-id'         => 'Numer VAT',
                ],
            ],

            'orders' => [
                'action'      => 'Akcja',
                'action-view' => 'Zobacz',
                'empty-order' => 'Nie zamówiłeś jeszcze żadnego produktu',
                'order'       => 'Zamówienie',
                'order-date'  => 'Data zamówienia',
                'order-id'    => 'ID zamówienia',
                'subtotal'    => 'Suma częściowa',
                'title'       => 'Zamówienia',
                'total'       => 'Razem',

                'status' => [
                    'title' => 'Status',

                    'options' => [
                        'canceled'        => 'Anulowane',
                        'closed'          => 'Zamknięte',
                        'completed'       => 'Zakończone',
                        'fraud'           => 'Oszustwo',
                        'pending'         => 'Oczekuje',
                        'pending-payment' => 'Oczekuje na płatność',
                        'processing'      => 'W trakcie realizacji',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Adres rozliczeniowy',
                    'cancel-btn-title'     => 'Anuluj',
                    'cancel-confirm-msg'   => 'Czy na pewno chcesz anulować to zamówienie?',
                    'cancel-error'         => 'Nie można anulować Twojego zamówienia.',
                    'cancel-success'       => 'Twoje zamówienie zostało anulowane',
                    'contact'              => 'Kontakt',
                    'item-invoiced'        => 'Pozycja faktury',
                    'item-refunded'        => 'Pozycja zwrócona',
                    'item-shipped'         => 'Pozycja wysłana',
                    'item-ordered'         => 'Pozycja zamówiona',
                    'order-id'             => 'Identyfikator zamówienia',
                    'page-title'           => 'Zamówienie #:order_id',
                    'payment-method'       => 'Metoda płatności',
                    'reorder-btn-title'    => 'Zamów ponownie',
                    'shipping-address'     => 'Adres dostawy',
                    'shipping-method'      => 'Metoda dostawy',
                    'shipping-and-payment' => 'Szczegóły dostawy i płatności',
                    'status'               => 'Status',
                    'title'                => 'Podgląd',
                    'total'                => 'Razem',

                    'information' => [
                        'discount'                   => 'Rabat',
                        'excl-tax'                   => 'Bez podatku:',
                        'grand-total'                => 'Suma ogólna',
                        'info'                       => 'Informacje',
                        'item-canceled'              => 'Anulowano (:qty_canceled)',
                        'item-refunded'              => 'Zwrócono (:qty_refunded)',
                        'invoiced-item'              => 'Fakturowane (:qty_invoiced)',
                        'item-shipped'               => 'wysłane (:qty_shipped)',
                        'item-status'                => 'Status pozycji',
                        'ordered-item'               => 'Zamówione (:qty_ordered)',
                        'placed-on'                  => 'Złożone',
                        'price'                      => 'Cena',
                        'product-name'               => 'Nazwa',
                        'shipping-handling'          => 'Dostawa i obsługa',
                        'shipping-handling-excl-tax' => 'Dostawa i obsługa (bez podatku)',
                        'shipping-handling-incl-tax' => 'Dostawa i obsługa (z podatkiem)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Suma częściowa',
                        'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
                        'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
                        'order-summary'              => 'Podsumowanie zamówienia',
                        'tax'                        => 'Podatek',
                        'tax-amount'                 => 'Kwota podatku',
                        'tax-percent'                => 'Procent podatku',
                        'total-due'                  => 'Całkowita należność',
                        'total-paid'                 => 'Całkowicie zapłacone',
                        'total-refunded'             => 'Całkowicie zwrócone',
                    ],

                    'invoices' => [
                        'discount'                   => 'Rabat',
                        'excl-tax'                   => 'Bez podatku:',
                        'grand-total'                => 'Suma ogólna',
                        'individual-invoice'         => 'Faktura #:invoice_id',
                        'invoices'                   => 'Faktury',
                        'price'                      => 'Cena',
                        'print'                      => 'Drukuj',
                        'product-name'               => 'Nazwa',
                        'products-ordered'           => 'Zamówione produkty',
                        'qty'                        => 'Ilość',
                        'shipping-handling-excl-tax' => 'Dostawa i obsługa (bez podatku)',
                        'shipping-handling-incl-tax' => 'Dostawa i obsługa (z podatkiem)',
                        'shipping-handling'          => 'Dostawa i obsługa',
                        'sku'                        => 'SKU',
                        'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
                        'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
                        'subtotal'                   => 'Suma częściowa',
                        'tax'                        => 'Podatek',
                        'tax-amount'                 => 'Kwota podatku',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Wysyłka #:shipment_id',
                        'product-name'        => 'Nazwa',
                        'qty'                 => 'Ilość',
                        'shipments'           => 'Wysyłki',
                        'sku'                 => 'SKU',
                        'subtotal'            => 'Suma częściowa',
                        'tracking-number'     => 'Numer przesyłki',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Opłata korekcyjna',
                        'adjustment-refund'          => 'Zwrot korekcyjny',
                        'discount'                   => 'Rabat',
                        'grand-total'                => 'Suma ogólna',
                        'individual-refund'          => 'Zwrot #:refund_id',
                        'no-result-found'            => 'Nie znaleziono żadnych rekordów.',
                        'order-summary'              => 'Podsumowanie zamówienia',
                        'price'                      => 'Cena',
                        'product-name'               => 'Nazwa',
                        'qty'                        => 'Ilość',
                        'refunds'                    => 'Zwroty',
                        'shipping-handling'          => 'Dostawa i obsługa',
                        'shipping-handling-excl-tax' => 'Dostawa i obsługa (bez podatku)',
                        'shipping-handling-incl-tax' => 'Dostawa i obsługa (z podatkiem)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Suma częściowa',
                        'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
                        'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
                        'tax'                        => 'Podatek',
                        'tax-amount'                 => 'Kwota podatku',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Dane bankowe',
                    'bill-to'                    => 'Faktura do',
                    'contact-number'             => 'Numer kontaktowy',
                    'contact'                    => 'Kontakt',
                    'date'                       => 'Data faktury',
                    'discount'                   => 'Rabat',
                    'excl-tax'                   => 'Bez podatku:',
                    'grand-total'                => 'Suma ogólna',
                    'invoice-id'                 => 'ID faktury',
                    'invoice'                    => 'Faktura',
                    'order-date'                 => 'Data zamówienia',
                    'order-id'                   => 'ID zamówienia',
                    'payment-method'             => 'Metoda płatności',
                    'payment-terms'              => 'Warunki płatności',
                    'price'                      => 'Cena',
                    'product-name'               => 'Nazwa produktu',
                    'qty'                        => 'Ilość',
                    'ship-to'                    => 'Wysyłka do',
                    'shipping-handling-excl-tax' => 'Koszty wysyłki i obsługi (bez podatku)',
                    'shipping-handling-incl-tax' => 'Koszty wysyłki i obsługi (z podatkiem)',
                    'shipping-handling'          => 'Koszty wysyłki i obsługi',
                    'shipping-method'            => 'Metoda wysyłki',
                    'sku'                        => 'SKU',
                    'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
                    'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
                    'subtotal'                   => 'Suma częściowa',
                    'tax-amount'                 => 'Kwota podatku',
                    'tax'                        => 'Podatek',
                    'vat-number'                 => 'Numer VAT',
                ],
            ],

            'reviews' => [
                'empty-review' => 'Nie wystawiłeś jeszcze recenzji produktu',
                'title'        => 'Recenzje',
            ],

            'downloadable-products' => [
                'available'           => 'Dostępny',
                'completed'           => 'Zakończony',
                'date'                => 'Data',
                'download-error'      => 'Link do pobrania wygasł.',
                'expired'             => 'Wygasło',
                'empty-product'       => 'Nie masz produktu do pobrania',
                'name'                => 'Produkty do pobrania',
                'orderId'             => 'Identyfikator zamówienia',
                'pending'             => 'Aż do',
                'payment-error'       => 'Nie dokonano płatności za to pobranie.',
                'records-found'       => 'Znaleziono rekord(y)',
                'remaining-downloads' => 'Pozostałe pobrania',
                'status'              => 'Status',
                'title'               => 'Tytuł',
            ],

            'wishlist' => [
                'color'              => 'Kolor',
                'delete-all'         => 'Usuń wszystko',
                'empty'              => 'Nie dodano jeszcze produktów do listy życzeń.',
                'move-to-cart'       => 'Przenieś do koszyka',
                'moved'              => 'Produkt został pomyślnie przeniesiony do koszyka',
                'moved-success'      => 'Produkt został pomyślnie przeniesiony do koszyka',
                'page-title'         => 'Lista życzeń',
                'product-removed'    => 'Produkt nie jest już dostępny, został usunięty przez administratora',
                'profile'            => 'Profil',
                'remove'             => 'Usuń',
                'remove-all-success' => 'Wszystkie elementy z twojej listy życzeń zostały usunięte',
                'remove-fail'        => 'Produkt nie może być usunięty z listy życzeń',
                'removed'            => 'Produkt został pomyślnie usunięty z listy życzeń',
                'see-details'        => 'Zobacz szczegóły',
                'success'            => 'Produkt został pomyślnie dodany do listy życzeń',
                'title'              => 'Lista życzeń',
            ],

            'gdpr' => [
                'create-success'              => 'Żądanie zostało pomyślnie utworzone',
                'revoked-successfully'        => 'Żądanie zostało pomyślnie cofnięte',
                'success-verify'              => 'Sukces! E-mail weryfikacyjny został wysłany.',
                'success-verify-email-unsent' => 'Sukces! E-mail weryfikacyjny nie został wysłany.',
                'unable-to-sent'              => 'Nie można wysłać e-maila.',

                'index'   => [
                    'create-btn' => 'Utwórz żądanie',
                    'html'       => 'HTML',
                    'pdf'        => 'PDF',
                    'title'      => 'Wnioski o dane RODO',

                    'modal' => [
                        'message' => 'Wiadomość',
                        'save'    => 'Zapisz',
                        'title'   => 'Utwórz nowe żądanie',

                        'type'    => [
                            'choose' => 'Wybierz',
                            'delete' => 'Usuń',
                            'title'  => 'Typ',
                            'update' => 'Aktualizuj',
                        ],
                    ],

                    'datagrid' => [
                        'completed'  => 'Zakończone',
                        'date'       => 'Data',
                        'declined'   => 'Odrzucone',
                        'delete'     => 'Usuń',
                        'id'         => 'ID',
                        'message'    => 'Wiadomość',
                        'pending'    => 'Oczekujące',
                        'processing' => 'Przetwarzanie',
                        'revoke-btn' => 'Odwołaj',
                        'revoked'    => 'Cofnięty',
                        'status'     => 'Status',
                        'type'       => 'Typ',
                        'update'     => 'Aktualizuj',
                    ],
                ],

                'pdf' => [
                    'title' => 'Domyślny widok sklepu',

                    'account-info' => [
                        'dob'          => 'Data urodzenia',
                        'email'        => 'E-mail',
                        'first-name'   => 'Imię',
                        'gender'       => 'Płeć',
                        'last-name'    => 'Nazwisko',
                        'phone'        => 'Telefon',
                        'title'        => 'Informacje o koncie',
                    ],

                    'address-info' => [
                        'address'    => 'Adres',
                        'address1'   => 'Adres 1',
                        'address2'   => 'Adres 2',
                        'city'       => 'Miasto',
                        'company'    => 'Firma',
                        'country'    => 'Kraj',
                        'first-name' => 'Imię',
                        'last-name'  => 'Nazwisko',
                        'phone'      => 'Telefon',
                        'postcode'   => 'Kod pocztowy',
                        'state'      => 'Województwo',
                        'title'      => 'Informacje adresowe',
                        'vat-id'     => 'NIP',
                    ],

                    'order-info' => [
                        'amount'       => 'Kwota',
                        'order-id'     => 'ID zamówienia',
                        'product-name' => 'Nazwa produktu',
                        'qty'          => 'Ilość',
                        'shipping'     => 'Wysyłka',
                        'sku'          => 'SKU',
                        'status'       => 'Status',
                        'title'        => 'Informacje o zamówieniu',
                        'type'         => 'Typ',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Domyślna zawartość',
            'default-header'  => 'Domyślny nagłówek',
        ],

        'drawer' => [
            'default-toggle'  => 'Domyślna zmiana',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Dodaj załączniki',
                'add-image'       => 'Dodaj Obraz/Wideo',
            ],
        ],

        'layouts' => [
            'header' => [
                'desktop' => [
                    'top' => [
                        'default-locale' => 'Domyślny język',
                    ],

                    'bottom' => [
                        'all'           => 'Wszystko',
                        'back-button'   => 'Powrót do menu głównego',
                        'bagisto'       => 'Bagisto',
                        'categories'    => 'Kategorie',
                        'compare'       => 'Porównaj',
                        'dropdown-text' => 'Zarządzaj koszykiem, zamówieniami i listą życzeń',
                        'logout'        => 'Wyloguj się',
                        'orders'        => 'Zamówienia',
                        'profile'       => 'Profil',
                        'search'        => 'Szukaj',
                        'search-text'   => 'Szukaj produktów tutaj',
                        'sign-in'       => 'Zaloguj się',
                        'sign-up'       => 'Zarejestruj się',
                        'submit'        => 'Wyślij',
                        'welcome'       => 'Witamy',
                        'welcome-guest' => 'Witamy gościa',
                        'wishlist'      => 'Lista życzeń',
                    ],
                ],

                'mobile' => [
                    'account'       => 'Konto',
                    'back-button'   => 'Powrót do menu głównego',
                    'bagisto'       => 'Bagisto',
                    'compare'       => 'Porównaj',
                    'currencies'    => 'Waluty',
                    'dropdown-text' => 'Zarządzaj koszykiem, zamówieniami i listą życzeń',
                    'locales'       => 'Języki',
                    'login'         => 'Zarejestruj się lub zaloguj',
                    'logout'        => 'Wyloguj się',
                    'orders'        => 'Zamówienia',
                    'profile'       => 'Profil',
                    'search'        => 'Szukaj',
                    'search-text'   => 'Szukaj produktów tutaj',
                    'sign-in'       => 'Zaloguj się',
                    'sign-up'       => 'Zarejestruj się',
                    'welcome'       => 'Witamy',
                    'welcome-guest' => 'Witamy gościa',
                    'wishlist'      => 'Lista życzeń',
                ],
            ],

            'footer' => [
                'about-us'               => 'O nas',
                'contact-us'             => 'Kontakt',
                'currency'               => 'Waluta',
                'customer-service'       => 'Obsługa klienta',
                'email'                  => 'Email',
                'footer-content'         => 'Treść stopki',
                'footer-text'            => '© Prawa autorskie 2010 - :current_year, Webkul Software (zarejestrowane w Indiach). Wszelkie prawa zastrzeżone.',
                'locale'                 => 'Lokalizacja',
                'newsletter-text'        => 'Bądź gotów na nasz zabawny biuletyn!',
                'order-return'           => 'Zamówienia i zwroty',
                'payment-policy'         => 'Polityka płatności',
                'privacy-cookies-policy' => 'Polityka prywatności i plików cookie',
                'shipping-policy'        => 'Polityka dostawy',
                'subscribe'              => 'Zapisz się',
                'subscribe-newsletter'   => 'Zapisz się na biuletyn',
                'subscribe-stay-touch'   => 'Zapisz się, aby być w kontakcie.',
                'whats-new'              => 'Co nowego',
            ],

            'cookie' => [
                'index' => [
                    'privacy-policy'           => 'Polityka prywatności',
                    'reject'                   => 'Odrzuć',
                    'accept'                   => 'Akceptuj',
                    'learn-more-and-customize' => 'Dowiedz się więcej i dostosuj',
                ],

                'consent' => [
                    'your-cookie-consent-preferences'         => 'Twoje preferencje dotyczące zgody na pliki cookie',
                    'save-and-continue'                       => 'Zapisz i kontynuuj',
                    'strictly-necessary'                      => 'Ściśle niezbędne',
                    'basic-interactions'                      => 'Podstawowe interakcje i funkcje',
                    'experience-enhancement'                  => 'Ulepszenie doświadczenia',
                    'measurements'                            => 'Pomiar',
                    'targeting-and-advertising'               => 'Targetowanie i reklama',
                ],
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length z',
                'results'   => ':total Wyniki',
                'selected'  => ':total Wybrane',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'Musisz wybrać akcję masową.',
                    'must-select-a-mass-action-option' => 'Musisz wybrać opcję akcji masowej.',
                    'no-records-selected'              => 'Nie wybrano żadnych rekordów.',
                    'select-action'                    => 'Wybierz akcję',
                ],

                'search' => [
                    'title' => 'Szukaj',
                ],

                'filter' => [
                    'apply-filter' => 'Zastosuj filtry',
                    'title'        => 'Filtruj',

                    'dropdown' => [
                        'select' => 'Wybierz',

                        'searchable' => [
                            'at-least-two-chars' => 'Wpisz co najmniej 2 znaki...',
                            'no-results'         => 'Nie znaleziono wyników...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Wyczyść wszystko',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Akcje',
                'next-page'            => 'Następna strona',
                'no-records-available' => 'Brak dostępnych rekordów.',
                'of'                   => 'z :total wpisów',
                'page-navigation'      => 'Nawigacja strony',
                'page-number'          => 'Numer strony',
                'previous-page'        => 'Poprzednia strona',
                'showing'              => 'Pokazuje :firstItem',
                'to'                   => 'do :lastItem',
            ],
        ],

        'modal' => [
            'default-content' => 'Domyślna zawartość',
            'default-header'  => 'Domyślny nagłówek',

            'confirm' => [
                'agree-btn'    => 'Zgadzam się',
                'disagree-btn' => 'Nie zgadzam się',
                'message'      => 'Czy na pewno chcesz wykonać tę akcję?',
                'title'        => 'Czy na pewno?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'Dodaj do koszyka',
                'add-to-compare'         => 'Dodaj do listy porównań',
                'add-to-compare-success' => 'Przedmiot został pomyślnie dodany do listy porównań.',
                'add-to-wishlist'        => 'Dodaj do listy życzeń',
                'already-in-compare'     => 'Przedmiot jest już dodany do listy porównań.',
                'new'                    => 'Nowy',
                'review-description'     => 'Bądź pierwszym, który oceni ten produkt',
                'sale'                   => 'Wyprzedaż',
            ],

            'carousel' => [
                'next'     => 'Następny',
                'previous' => 'Poprzedni',
                'view-all' => 'Pokaż Wszystko',
            ],

            'ratings' => [
                'title' => 'Oceny',
            ],
        ],

        'range-slider' => [
            'max-range' => 'Maksymalny Zakres',
            'min-range' => 'Minimalny Zakres',
            'range'     => 'Zakres:',
        ],

        'carousel' => [
            'image-slide' => 'Obrazek Slajdu',
            'next'        => 'Następny',
            'previous'    => 'Poprzedni',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Zmniejsz Ilość',
            'increase-quantity' => 'Zwiększ Ilość',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'Począwszy od',
            ],

            'configurable' => [
                'as-low-as' => 'Już od',
            ],
        ],

        'sort-by' => [
            'title'   => 'Sortuj według',
        ],

        'view' => [
            'type' => [
                'simple' => [
                    'customizable-options' => [
                        'none'         => 'Brak',
                        'total-amount' => 'Całkowita kwota',
                    ],
                ],

                'configurable' => [
                    'select-options'       => 'Wybierz opcję',
                    'select-above-options' => 'Wybierz powyższe opcje',
                ],

                'bundle' => [
                    'none'         => 'Brak',
                    'total-amount' => 'Całkowita Kwota',
                ],

                'downloadable' => [
                    'links'   => 'Łącza',
                    'sample'  => 'Przykład',
                    'samples' => 'Przykłady',
                ],

                'grouped' => [
                    'name' => 'Nazwa',
                ],

                'booking' => [
                    'location'    => 'Lokalizacja',
                    'view-on-map' => 'Zobacz na mapie',

                    'default' => [
                        'slot-duration-in-minutes' => ':minutes Minut',
                        'slot-duration'            => 'Czas trwania slotu',
                    ],

                    'appointment' => [
                        'closed'                   => 'Zamknięte',
                        'see-details'              => 'Zobacz szczegóły',
                        'slot-duration'            => 'Czas trwania slotu',
                        'slot-duration-in-minutes' => ':minutes Minut',
                        'today-availability'       => 'Dostępność dzisiaj',
                    ],

                    'event' => [
                        'book-your-ticket' => 'Zarezerwuj bilet',
                        'title'            => 'Wydarzenie dnia :',
                    ],

                    'rental'      => [
                        'choose-rent-option' => 'Wybierz opcję wynajmu',
                        'daily-basis'        => 'Na dzień',
                        'from'               => 'Od',
                        'hourly-basis'       => 'Na godzinę',
                        'rent-an-item'       => 'Wynajmij przedmiot',
                        'select-date'        => 'Wybierz datę',
                        'select-rent-time'   => 'Wybierz czas wynajmu',
                        'select-slot'        => 'Wybierz slot',
                        'select-time-slot'   => 'Wybierz przedział czasowy',
                        'slot'               => 'Slot',
                        'no-slots-available' => 'Brak dostępnych slotów',
                        'to'                 => 'Do',
                    ],

                    'table'       => [
                        'book-a-table'             => 'Zarezerwuj stolik',
                        'closed'                   => 'Zamknięte',
                        'slot-duration'            => 'Czas trwania slotu',
                        'slot-duration-in-minutes' => ':minutes Minut',
                        'slots-for-all-days'       => 'Pokaż dla wszystkich dni',
                        'special-notes'            => 'Specjalne prośby/uwagi',
                        'today-availability'       => 'Dostępność dzisiaj',
                    ],

                    'slots' => [
                        'book-an-appointment' => 'Zarezerwuj wizytę',
                        'date'                => 'Data',
                        'no-slots-available'  => 'Brak dostępnych slotów',
                        'select-slot'         => 'Wybierz slot',
                        'title'               => 'Slot',
                    ],
                ],
            ],

            'gallery' => [
                'product-image'   => 'Zdjęcie produktu',
                'thumbnail-image' => 'Miniaturka zdjęcia',
            ],

            'reviews' => [
                'attachments'      => 'Załączniki',
                'cancel'           => 'Anuluj',
                'comment'          => 'Komentarz',
                'customer-review'  => 'Recenzje klientów',
                'empty-review'     => 'Nie znaleziono recenzji, bądź pierwszym, który oceni ten produkt',
                'failed-to-upload' => 'Nie udało się przesłać obrazka',
                'load-more'        => 'Wczytaj więcej',
                'name'             => 'Imię',
                'rating'           => 'Ocena',
                'ratings'          => 'Oceny',
                'submit-review'    => 'Prześlij recenzję',
                'success'          => 'Recenzja została pomyślnie przesłana.',
                'title'            => 'Tytuł',
                'translate'        => 'Tłumaczyć',
                'translating'      => 'Tłumaczenie...',
                'write-a-review'   => 'Napisz recenzję',
            ],

            'add-to-cart'            => 'Dodaj do koszyka',
            'add-to-compare'         => 'Produkt dodany do porównania.',
            'add-to-wishlist'        => 'Dodaj do listy życzeń',
            'additional-information' => 'Dodatkowe informacje',
            'already-in-compare'     => 'Produkt jest już w porównaniu.',
            'buy-now'                => 'Kup teraz',
            'compare'                => 'Porównaj',
            'description'            => 'Opis',
            'related-product-title'  => 'Powiązane produkty',
            'review'                 => 'Recenzje',
            'tax-inclusive'          => 'Wliczając wszystkie podatki',
            'up-sell-title'          => 'Znaleźliśmy inne produkty, które mogą Ci się spodobać!',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Kup :qty za :price każdy i zaoszczędź :discount',
            ],
        ],

        'booking' => [
            'closed' => 'Zamknięte',

            'cart'             => [
                'booking-from' => 'Rezerwacja od',
                'booking-till' => 'Rezerwacja do',
                'daily'        => 'Na dzień',
                'event-from'   => 'Wydarzenie od',
                'event-ticket' => 'Bilet na wydarzenie',
                'event-till'   => 'Wydarzenie do',
                'hourly'       => 'Na godzinę',

                'integrity'    => [
                    'event'                  => [
                        'expired' => 'To wydarzenie wygasło.',
                    ],

                    'missing_options'        => 'Brakujące opcje dla tego produktu.',
                    'inventory_warning'      => 'Żądana ilość nie jest dostępna, prosimy spróbować ponownie później.',
                    'select_hourly_duration' => 'Wybierz czas trwania jednej godziny.',
                ],

                'rent-from'    => 'Wynajem od',
                'rent-till'    => 'Wynajem do',
                'rent-type'    => 'Typ wynajmu',
                'renting_type' => 'Typ wynajmu',
                'special-note' => 'Specjalne prośby/uwagi',
            ],

            'per-ticket-price' => ':price za bilet',
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Wyczyść wszystko',
            'filter'    => 'Filtr',
            'filters'   => 'Filtry:',

            'search' => [
                'load-more'            => 'Załaduj więcej',
                'loading'              => 'Ładowanie...',
                'no-options-available' => 'Brak dostępnych opcji.',
                'results-info'         => 'Wyświetlanie :currentCount z :totalCount opcji',
                'title'                => 'Szukaj',
            ],

            'sort'      => 'Sortuj',
        ],

        'toolbar' => [
            'grid' => 'Siatka',
            'list' => 'Lista',
            'show' => 'Pokaż',
        ],

        'view' => [
            'empty'     => 'Brak dostępnych produktów w tej kategorii',
            'load-more' => 'Wczytaj więcej',
        ],
    ],

    'search' => [
        'title'   => 'Wyniki wyszukiwania dla: :query',
        'results' => 'Wyniki wyszukiwania',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Dozwolone są tylko obrazy (.jpeg, .jpg, .png, ..).',
                'search'               => 'Szukaj',
                'size-limit-error'     => 'Błąd Limitu Rozmiaru',
                'something-went-wrong' => 'Coś poszło nie tak, spróbuj ponownie później.',
            ],

            'results' => [
                'analyzed-keywords' => 'Zanalizowane Słowa Kluczowe:',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'Produkt jest już dodany do listy porównawczej',
        'delete-all'         => 'Usuń wszystko',
        'empty-text'         => 'Nie masz żadnych produktów na liście porównawczej',
        'item-add-success'   => 'Produkt został pomyślnie dodany do listy porównawczej',
        'product-compare'    => 'Porównanie produktów',
        'remove-all-success' => 'Wszystkie produkty zostały pomyślnie usunięte',
        'remove-error'       => 'Coś poszło nie tak, spróbuj ponownie później',
        'remove-success'     => 'Produkt został pomyślnie usunięty',
        'title'              => 'Porównanie produktów',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'Wyślemy Ci e-mail z danymi Twojego zamówienia oraz informacjami o śledzeniu przesyłki',
            'order-id-info' => 'Twój numer zamówienia to #:order_id',
            'thanks'        => 'Dziękujemy za Twoje zamówienie!',
            'title'         => 'Zamówienie złożone pomyślnie',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Przejdź do realizacji zamówienia',
            'illegal'                   => 'Ilość nie może być mniejsza niż jeden',
            'inactive-add'              => 'Nieaktywny produkt nie może zostać dodany do koszyka.',
            'inactive'                  => 'Produkt został dezaktywowany i usunięty z koszyka',
            'inventory-warning'         => 'Żądana ilość nie jest dostępna, prosimy spróbować ponownie później',
            'item-add-to-cart'          => 'Produkt został pomyślnie dodany do koszyka',
            'minimum-order-message'     => 'Minimalna wartość zamówienia wynosi',
            'missing-fields'            => 'Brakujące wymagane pola dla tego produktu',
            'missing-options'           => 'Brakujące opcje dla tego produktu',
            'paypal-payment-cancelled'  => 'Płatność PayPal została anulowana.',
            'qty-missing'               => 'Przynajmniej jeden produkt musi mieć ilość większą niż 1',
            'return-to-shop'            => 'Wróć do sklepu',
            'rule-applied'              => 'Zastosowano zniżkę koszyka',
            'select-hourly-duration'    => 'Wybierz czas trwania jednej godziny',
            'success-remove'            => 'Produkt został pomyślnie usunięty z koszyka',
            'suspended-account-message' => 'Twoje konto zostało zawieszone',

            'index' => [
                'bagisto'                  => 'Bagisto',
                'cart'                     => 'Koszyk',
                'continue-shopping'        => 'Kontynuuj zakupy',
                'empty-product'            => 'Nie masz produktu w koszyku',
                'excl-tax'                 => 'Bez podatku:',
                'home'                     => 'Strona główna',
                'items-selected'           => ':count wybranych produktów',
                'move-to-wishlist'         => 'Przenieś na listę życzeń',
                'move-to-wishlist-success' => 'Wybrane produkty zostały pomyślnie przeniesione na listę życzeń',
                'price'                    => 'Cena',
                'product-name'             => 'Nazwa produktu',
                'quantity'                 => 'Ilość',
                'quantity-update'          => 'Ilość została pomyślnie zaktualizowana',
                'remove'                   => 'Usuń',
                'remove-selected-success'  => 'Wybrane produkty zostały pomyślnie usunięte z koszyka',
                'see-details'              => 'Zobacz szczegóły',
                'select-all'               => 'Zaznacz wszystko',
                'select-cart-item'         => 'Zaznacz element koszyka',
                'tax'                      => 'Podatek',
                'total'                    => 'Suma',
                'update-cart'              => 'Aktualizuj koszyk',
                'view-cart'                => 'Zobacz koszyk',

                'cross-sell' => [
                    'title' => 'Więcej opcji',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Przejdź do realizacji zamówienia',
                'empty-cart'           => 'Twój koszyk jest pusty',
                'excl-tax'             => 'Bez podatku:',
                'offer-on-orders'      => 'Zyskaj do 30% RABATU na swoje pierwsze zamówienie',
                'remove'               => 'Usuń',
                'see-details'          => 'Zobacz szczegóły',
                'shopping-cart'        => 'Koszyk',
                'subtotal'             => 'Suma częściowa',
                'view-cart'            => 'Zobacz koszyk',
            ],

            'summary' => [
                'cart-summary'              => 'Podsumowanie koszyka',
                'delivery-charges-excl-tax' => 'Opłaty za dostawę (bez podatku)',
                'delivery-charges-incl-tax' => 'Opłaty za dostawę (z podatkiem)',
                'delivery-charges'          => 'Opłaty za dostawę',
                'discount-amount'           => 'Kwota rabatu',
                'grand-total'               => 'Suma ogólna',
                'place-order'               => 'Złóż zamówienie',
                'proceed-to-checkout'       => 'Przejdź do realizacji zamówienia',
                'sub-total-excl-tax'        => 'Suma częściowa (bez podatku)',
                'sub-total-incl-tax'        => 'Suma częściowa (z podatkiem)',
                'sub-total'                 => 'Suma częściowa',
                'tax'                       => 'Podatek',

                'estimate-shipping' => [
                    'country'        => 'Kraj',
                    'info'           => 'Wprowadź miejsce docelowe, aby uzyskać szacunkowy koszt wysyłki i podatku.',
                    'postcode'       => 'Kod pocztowy',
                    'select-country' => 'Wybierz kraj',
                    'select-state'   => 'Wybierz województwo',
                    'state'          => 'Województwo',
                    'title'          => 'Szacowanie kosztów wysyłki i podatku',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Dodaj nowy adres',
                'add-new-address'        => 'Dodaj nowy adres',
                'back'                   => 'Wstecz',
                'billing-address'        => 'Adres rozliczeniowy',
                'check-billing-address'  => 'Brakuje adresu rozliczeniowego.',
                'check-shipping-address' => 'Brakuje adresu dostawy.',
                'city'                   => 'Miasto',
                'company-name'           => 'Nazwa firmy',
                'confirm'                => 'Potwierdź',
                'country'                => 'Kraj',
                'email'                  => 'E-mail',
                'first-name'             => 'Imię',
                'last-name'              => 'Nazwisko',
                'postcode'               => 'Kod pocztowy',
                'proceed'                => 'Kontynuuj',
                'same-as-billing'        => 'Użyć tego samego adresu do wysyłki?',
                'save'                   => 'Zapisz',
                'save-address'           => 'Zapisz w książce adresowej',
                'select-country'         => 'Wybierz kraj',
                'select-state'           => 'Wybierz województwo',
                'shipping-address'       => 'Adres dostawy',
                'state'                  => 'Województwo',
                'street-address'         => 'Adres ulicy',
                'telephone'              => 'Telefon',
                'title'                  => 'Adres',
                'vat-id'                 => 'Numer VAT',
            ],

            'index' => [
                'checkout' => 'Zamówienie',
                'home'     => 'Strona główna',
            ],

            'payment' => [
                'payment-method' => 'Metoda płatności',
            ],

            'shipping' => [
                'shipping-method' => 'Metoda dostawy',
            ],

            'summary' => [
                'cart-summary'              => 'Podsumowanie koszyka',
                'delivery-charges-excl-tax' => 'Opłaty za dostawę (bez podatku)',
                'delivery-charges-incl-tax' => 'Opłaty za dostawę (z podatkiem)',
                'delivery-charges'          => 'Opłaty za dostawę',
                'discount-amount'           => 'Kwota rabatu',
                'excl-tax'                  => 'Bez podatku:',
                'grand-total'               => 'Suma ogólna',
                'place-order'               => 'Złóż zamówienie',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'Przetwarzanie',
                'sub-total-excl-tax'        => 'Suma częściowa (bez podatku)',
                'sub-total-incl-tax'        => 'Suma częściowa (z podatkiem)',
                'sub-total'                 => 'Suma częściowa',
                'tax'                       => 'Podatek',
            ],
        ],

        'coupon' => [
            'already-applied' => 'Kod kuponu jest już zastosowany',
            'applied'         => 'Kod kuponu został zastosowany',
            'apply'           => 'Zastosuj kod kuponu',
            'apply-issue'     => 'Kod kuponu nie może być zastosowany',
            'button-title'    => 'Zastosuj',
            'code'            => 'Kod kuponu',
            'discount'        => 'Rabat z kuponu',
            'enter-your-code' => 'Wprowadź swój kod',
            'error'           => 'Coś poszło nie tak',
            'invalid'         => 'Kod kuponu jest nieprawidłowy',
            'remove'          => 'Usuń kupon',
            'subtotal'        => 'Suma częściowa',
            'success-apply'   => 'Kod kuponu został pomyślnie zastosowany',
        ],

        'login' => [
            'email'    => 'E-mail',
            'password' => 'Hasło',
            'title'    => 'Zaloguj się',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Napisz do nas, a odpowiemy tak szybko, jak to możliwe',
            'desc'          => 'Co Cię nurtuje?',
            'describe-here' => 'Opisz tutaj',
            'email'         => 'E-mail',
            'message'       => 'Wiadomość',
            'name'          => 'Imię',
            'phone-number'  => 'Numer telefonu',
            'submit'        => 'Wyślij',
            'title'         => 'Skontaktuj się z nami',
        ],

        'index' => [
            'categories-carousel' => 'Karuzela kategorii',
            'image-carousel'      => 'Karuzela obrazów',
            'offer'               => 'Otrzymaj DO 40% RABATU na swoje pierwsze zamówienie, ZAKUP TERAZ',
            'product-carousel'    => 'Karuzela produktów',
            'resend-verify-email' => 'Wyślij ponownie e-mail weryfikacyjny',
            'verify-email'        => 'Zweryfikuj swoje konto e-mail',
        ],

        'thanks-for-contact' => 'Dziękujemy za skontaktowanie się z nami. Odpowiemy na Twoje uwagi i pytania wkrótce.',
    ],

    'partials' => [
        'pagination' => [
            'next-page'          => 'Następna strona',
            'pagination-showing' => 'Wyświetlanie :firstItem do :lastItem z :total wpisów',
            'prev-page'          => 'Poprzednia strona',
        ],
    ],

    'errors' => [
        'go-to-home'   => 'Przejdź na stronę główną',

        '404' => [
            'description' => 'Ups! Strona, którą szukasz, jest na wakacjach. Wygląda na to, że nie możemy znaleźć tego, czego szukasz.',
            'title'       => '404 Strona nie znaleziona',
        ],

        '401' => [
            'description' => 'Ups! Wygląda na to, że nie masz dostępu do tej strony. Wydaje się, że brakuje Ci niezbędnych uprawnień.',
            'title'       => '401 Nieautoryzowany',
        ],

        '403' => [
            'description' => 'Ups! Ta strona jest niedostępna. Wygląda na to, że nie masz wymaganych uprawnień do przeglądania tego treści.',
            'title'       => '403 Dostęp zabroniony',
        ],

        '500' => [
            'description' => 'Ups! Coś poszło nie tak. Wydaje się, że mamy problemy z załadowaniem strony, której szukasz.',
            'title'       => '500 Wewnętrzny błąd serwera',
        ],

        '503' => [
            'description' => 'Ups! Wygląda na to, że jesteśmy tymczasowo wyłączeni z powodu prac konserwacyjnych. Proszę wrócić za chwilę.',
            'title'       => '503 Usługa niedostępna',
        ],
    ],

    'layouts' => [
        'address'               => 'Adres',
        'downloadable-products' => 'Produkty do pobrania',
        'gdpr-request'          => 'Żądania GDPR',
        'my-account'            => 'Moje konto',
        'orders'                => 'Zamówienia',
        'profile'               => 'Profil',
        'reviews'               => 'Recenzje',
        'wishlist'              => 'Lista życzeń',
    ],

    'subscription' => [
        'already'             => 'Jesteś już zapisany do naszego newslettera.',
        'subscribe-success'   => 'Zostałeś pomyślnie zapisany do naszego newslettera.',
        'unsubscribe-success' => 'Zostałeś pomyślnie wypisany z naszego newslettera.',
    ],

    'emails' => [
        'dear'   => 'Szanowny :customer_name',
        'thanks' => 'Jeśli potrzebujesz pomocy, skontaktuj się z nami pod adresem <a href=":link" style=":style">:email</a>.<br/>Dziękujemy!',

        'customers' => [
            'registration' => [
                'credentials-description' => 'Sua conta foi criada. Os detalhes da sua conta estão abaixo:',
                'description'             => 'Twoje konto zostało teraz pomyślnie utworzone, możesz się zalogować za pomocą swojego adresu e-mail i hasła. Po zalogowaniu będziesz mógł korzystać z innych usług, w tym przeglądania wcześniejszych zamówień, list życzeń i edytowania informacji o koncie.',
                'greeting'                => 'Witamy i dziękujemy za zarejestrowanie się u nas!',
                'password'                => 'Senha',
                'sign-in'                 => 'Zaloguj się',
                'subject'                 => 'Rejestracja nowego klienta',
                'username'                => 'Nome de usuário/Email',
            ],

            'forgot-password' => [
                'description'    => 'Otrzymujesz ten e-mail, ponieważ otrzymaliśmy prośbę o zresetowanie hasła do Twojego konta.',
                'greeting'       => 'Zapomniałeś hasła!',
                'reset-password' => 'Zresetuj hasło',
                'subject'        => 'E-mail z resetem hasła',
            ],

            'update-password' => [
                'description' => 'Otrzymujesz ten e-mail, ponieważ zaktualizowałeś swoje hasło.',
                'greeting'    => 'Hasło zostało zaktualizowane!',
                'subject'     => 'Aktualizacja hasła',
            ],

            'verification' => [
                'description'  => 'Proszę kliknąć poniższy przycisk, aby zweryfikować swój adres e-mail.',
                'greeting'     => 'Witaj!',
                'subject'      => 'E-mail z weryfikacją konta',
                'verify-email' => 'Zweryfikuj adres e-mail',
            ],

            'commented' => [
                'description' => 'Notatka to - :note',
                'subject'     => 'Dodano nowy komentarz',
            ],

            'subscribed' => [
                'description' => 'Gratulacje i witamy w naszej społeczności newslettera! Jesteśmy podekscytowani, że jesteś z nami i będziemy Cię informować o najnowszych wiadomościach, trendach i ekskluzywnych ofertach.',
                'greeting'    => 'Witaj w naszym newsletterze!',
                'subject'     => 'Zapisano się na nasz newsletter',
                'unsubscribe' => 'Wypisz się',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nowe żądanie usunięcia danych',
                'new-update-request' => 'Nowe żądanie aktualizacji danych',

                'new-request' => [
                    'delete-summary' => 'Podsumowanie żądania usunięcia',
                    'message'        => 'Wiadomość : ',
                    'request-status' => 'Status żądania : ',
                    'request-type'   => 'Typ żądania : ',
                    'update-summary' => 'Podsumowanie żądania aktualizacji',
                ],

                'status-update' => [
                    'subject'        => 'Twój wniosek GDPR został zaktualizowany',
                    'summary'        => 'Status twojego wniosku GDPR został zaktualizowany',
                    'request-status' => 'Status żądania:',
                    'request-type'   => 'Typ żądania:',
                    'message'        => 'Wiadomość:',
                ],
            ],

            'reminder' => [
                'already-paid'    => 'Jeśli już dokonałeś płatności, zignoruj tę wiadomość.',
                'invoice-overdue' => 'To uprzejme przypomnienie, że twoja faktura jest zaległa. Prosimy o dokonanie płatności najszybciej, jak to możliwe.',
                'subject'         => 'Przypomnienie o fakturze',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'za pośrednictwem formularza kontaktowego na stronie',
            'reply-to-mail'   => 'prosimy o odpowiedź na ten adres e-mail.',
            'reach-via-phone' => 'Alternatywnie, możesz się z nami skontaktować telefonicznie pod numerem',
            'inquiry-from'    => 'Zapytanie od',
            'to'              => 'Aby skontaktować się z',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Dziękujemy za Twoje zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie nowego zamówienia',
                'summary'  => 'Podsumowanie zamówienia',
                'title'    => 'Potwierdzenie zamówienia!',
            ],

            'invoiced' => [
                'greeting' => 'Twoja faktura #:invoice_id dla zamówienia :order_id utworzona :created_at',
                'subject'  => 'Potwierdzenie nowej faktury',
                'summary'  => 'Podsumowanie faktury',
                'title'    => 'Potwierdzenie faktury!',
            ],

            'shipped' => [
                'greeting' => 'Twoje zamówienie :order_id złożone :created_at zostało wysłane',
                'subject'  => 'Potwierdzenie nowej przesyłki',
                'summary'  => 'Podsumowanie przesyłki',
                'title'    => 'Zamówienie wysłane!',
            ],

            'refunded' => [
                'greeting' => 'Rozpoczęto zwrot środków za zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie nowego zwrotu środków',
                'summary'  => 'Podsumowanie zwrotu',
                'title'    => 'Zamówienie zwrócone!',
            ],

            'canceled' => [
                'greeting' => 'Twoje zamówienie :order_id złożone :created_at zostało anulowane',
                'subject'  => 'Nowe potwierdzenie anulowania zamówienia',
                'summary'  => 'Podsumowanie zamówienia',
                'title'    => 'Zamówienie anulowane!',
            ],

            'commented' => [
                'subject' => 'Dodano nowy komentarz',
                'title'   => 'Dodano nowy komentarz do zamówienia :order_id złożonego :created_at',
            ],

            'billing-address'            => 'Adres rozliczeniowy',
            'carrier'                    => 'Przewoźnik',
            'contact'                    => 'Kontakt',
            'discount'                   => 'Rabat',
            'excl-tax'                   => 'Bez podatku: ',
            'grand-total'                => 'Suma całkowita',
            'name'                       => 'Nazwa',
            'payment'                    => 'Płatność',
            'price'                      => 'Cena',
            'qty'                        => 'Ilość',
            'shipping-address'           => 'Adres dostawy',
            'shipping-handling-excl-tax' => 'Obsługa wysyłki (bez podatku)',
            'shipping-handling-incl-tax' => 'Obsługa wysyłki (z podatkiem)',
            'shipping-handling'          => 'Obsługa wysyłki',
            'shipping'                   => 'Wysyłka',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
            'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
            'subtotal'                   => 'Suma częściowa',
            'tax'                        => 'Podatek',
            'tracking-number'            => 'Numer śledzenia: :tracking_number',
        ],
    ],
];
